/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1939", name="Extensions and implementations should not be redundant", priority=Priority.MINOR, tags={"clumsy"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="1min")
public class UselessExtendsCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        ClassTree classTree = (ClassTree)tree;
        this.checkExtendsObject(classTree);
        ListTree superInterfaces = classTree.superInterfaces();
        if (superInterfaces.isEmpty()) {
            return;
        }
        Set superTypes = ((JavaSymbol.TypeJavaSymbol)classTree.symbol()).superTypes();
        List<Type> superInterfacesTypes = UselessExtendsCheck.getTypes((ListTree<TypeTree>)superInterfaces);
        HashSet<String> reportedNames = new HashSet<String>();
        for (TypeTree superInterface : superInterfaces) {
            String superInterfaceName = UselessExtendsCheck.extractInterfaceName((Tree)superInterface);
            if (UselessExtendsCheck.isDuplicate((ListTree<TypeTree>)superInterfaces, superInterface) && !reportedNames.add(superInterfaceName)) {
                this.reportIssue((Tree)superInterface, "\"" + superInterfaceName + "\" is listed multiple times.");
            }
            if (superInterface.symbolType().isUnknown()) continue;
            this.checkRedundancy(superInterface, superInterfacesTypes, superTypes);
        }
    }

    private void checkExtendsObject(ClassTree classTree) {
        TypeTree superClassTree = classTree.superClass();
        if (superClassTree != null && superClassTree.symbolType().is("java.lang.Object")) {
            this.reportIssue((Tree)superClassTree, "\"Object\" should not be explicitly extended.");
        }
    }

    private static boolean isDuplicate(ListTree<TypeTree> superInterfaces, TypeTree currentInterfaceTree) {
        for (TypeTree superInterfaceTree : superInterfaces) {
            if (currentInterfaceTree.equals(superInterfaceTree) || !SyntacticEquivalence.areEquivalent((Tree)currentInterfaceTree, (Tree)superInterfaceTree)) continue;
            return true;
        }
        return false;
    }

    private static List<Type> getTypes(ListTree<TypeTree> superInterfaces) {
        ArrayList<Type> types = new ArrayList<Type>(superInterfaces.size());
        for (TypeTree superInterface : superInterfaces) {
            types.add(superInterface.symbolType());
        }
        return types;
    }

    private void checkRedundancy(TypeTree currentInterface, List<Type> superInterfacesTypes, Set<JavaType.ClassJavaType> superTypes) {
        Type interfaceType = currentInterface.symbolType();
        for (JavaType.ClassJavaType superType : superTypes) {
            Symbol.TypeSymbol superTypeSymbol = superType.symbol();
            if (!superTypeSymbol.interfaces().contains(interfaceType)) continue;
            String typeOfParentMsg = "implemented by a super class";
            if (superTypeSymbol.isInterface() && superInterfacesTypes.contains(superType)) {
                typeOfParentMsg = "already extended by \"" + superTypeSymbol.name() + "\"";
            }
            this.reportIssue((Tree)currentInterface, "\"" + interfaceType.name() + "\" is " + typeOfParentMsg + "; there is no need to implement it here.");
            break;
        }
    }

    private static String extractInterfaceName(Tree interfaceTree) {
        if (interfaceTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)interfaceTree).name();
        }
        if (interfaceTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)interfaceTree;
            return UselessExtendsCheck.extractInterfaceName((Tree)mset.expression()) + "." + mset.identifier().name();
        }
        return UselessExtendsCheck.extractInterfaceName((Tree)((ParameterizedTypeTree)interfaceTree).type());
    }
}

