/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.naming;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00115", name="Constant names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BadConstantNameCheck
extends IssuableSubscriptionVisitor {
    private static final String DEFAULT_FORMAT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    @RuleProperty(key="format", description="Regular expression used to check the constant names against.", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    public String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && this.hasSemantic()) {
                VariableTree variableTree = (VariableTree)member;
                Type symbolType = variableTree.type().symbolType();
                if (!BadConstantNameCheck.isConstantType(symbolType) || !classTree.is(new Tree.Kind[]{Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE}) && !BadConstantNameCheck.isStaticFinal(variableTree)) continue;
                this.checkName(variableTree);
                continue;
            }
            if (!member.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT})) continue;
            this.checkName((VariableTree)member);
        }
    }

    private static boolean isConstantType(Type symbolType) {
        return symbolType.isPrimitive() || symbolType.is("java.lang.String") || ((JavaType)symbolType).isPrimitiveWrapper();
    }

    private void checkName(VariableTree variableTree) {
        if (!"serialVersionUID".equals(variableTree.simpleName().name()) && !this.pattern.matcher(variableTree.simpleName().name()).matches()) {
            this.reportIssue((Tree)variableTree.simpleName(), "Rename this constant name to match the regular expression '" + this.format + "'.");
        }
    }

    private static boolean isStaticFinal(VariableTree variableTree) {
        boolean isStatic = false;
        boolean isFinal = false;
        for (ModifierKeywordTree modifierKeywordTree : variableTree.modifiers().modifiers()) {
            Modifier modifier = modifierKeywordTree.modifier();
            if (modifier == Modifier.STATIC) {
                isStatic = true;
            }
            if (modifier != Modifier.FINAL) continue;
            isFinal = true;
        }
        return isStatic && isFinal;
    }
}

