/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2326", name="Unused type parameters should be removed", priority=Priority.MAJOR, tags={"unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedTypeParameterCheck
extends IssuableSubscriptionVisitor {
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            String messageEnd;
            TypeParameters typeParameters;
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                typeParameters = ((MethodTree)tree).typeParameters();
                messageEnd = "method.";
            } else {
                typeParameters = ((ClassTree)tree).typeParameters();
                messageEnd = "class.";
                if (tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE})) {
                    messageEnd = "interface.";
                }
            }
            for (TypeParameterTree typeParameter : typeParameters) {
                Symbol symbol = this.semanticModel.getSymbol((Tree)typeParameter);
                if (!symbol.usages().isEmpty()) continue;
                String message = typeParameter.identifier().name() + " is not used in the " + messageEnd;
                this.reportIssue((Tree)typeParameter.identifier(), message);
            }
        }
    }
}

