/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.ejb;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.xml.XPathXmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.w3c.dom.Node;

@Rule(key="S3281", name="Default EJB interceptors should be declared in \"ejb-jar.xml\"", priority=Priority.MAJOR, tags={"bug"})
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class DefaultInterceptorsLocationCheck
extends XPathXmlCheck {
    private XPathExpression defaultInterceptorClassesExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.defaultInterceptorClassesExpression = context.compile("ejb-jar/assembly-descriptor/interceptor-binding[ejb-name=\"*\"]/interceptor-class");
    }

    public void scanFileWithXPathExpressions(XmlCheckContext context) {
        if (!"ejb-jar.xml".equalsIgnoreCase(context.getFile().getName())) {
            for (Node interceptorClass : context.evaluateOnDocument(this.defaultInterceptorClassesExpression)) {
                this.reportIssue(interceptorClass, "Move this default interceptor to \"ejb-jar.xml\"");
            }
        }
    }
}

