/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.maven.helpers;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.java.checks.xml.maven.helpers.LocatedAttributeMatcher;
import org.sonar.maven.model.LocatedAttribute;

public class RangedVersionMatcher
implements LocatedAttributeMatcher {
    @Nullable
    private final ArtifactVersion lowerBound;
    @Nullable
    private final ArtifactVersion upperBound;

    public RangedVersionMatcher(String lowerBound, String upperBound) {
        this.lowerBound = RangedVersionMatcher.isWildCard(lowerBound) ? null : RangedVersionMatcher.getVersion(lowerBound);
        this.upperBound = RangedVersionMatcher.isWildCard(upperBound) ? null : RangedVersionMatcher.getVersion(upperBound);
        Preconditions.checkArgument((this.lowerBound != null || this.upperBound != null ? 1 : 0) != 0);
    }

    private static boolean isWildCard(String pattern) {
        return "*".equals(pattern);
    }

    private static ArtifactVersion getVersion(String version) {
        try {
            return ArtifactVersion.parseString(version);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Provided version does not match expected pattern: <major version>.<minor version>.<incremental version> (recieved: " + version + ")", e);
        }
    }

    @Override
    public boolean matches(@Nullable LocatedAttribute attribute) {
        if (attribute == null) {
            return false;
        }
        ArtifactVersion dependencyVersion = RangedVersionMatcher.getVersionSilently(attribute.getValue());
        if (dependencyVersion == null) {
            return false;
        }
        boolean matchesLowerBound = this.lowerBound == null || dependencyVersion.isAfterOrEqual(this.lowerBound);
        boolean matchesUpperBound = this.upperBound == null || this.upperBound.isAfterOrEqual(dependencyVersion);
        return matchesLowerBound && matchesUpperBound;
    }

    @CheckForNull
    private static ArtifactVersion getVersionSilently(String version) {
        try {
            return ArtifactVersion.parseString(version);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static class ArtifactVersion {
        private static final int HANDLED_VERSIONS = 3;
        private final Integer[] versions = new Integer[3];

        private ArtifactVersion() {
        }

        private static ArtifactVersion parseString(String version) {
            String[] split = version.split("\\.");
            if (version.contains("-")) {
                split = version.split("-")[0].split("\\.");
            }
            ArtifactVersion result = new ArtifactVersion();
            for (int i = 0; i < Math.min(3, split.length); ++i) {
                result.versions[i] = Integer.parseInt(split[i]);
            }
            return result;
        }

        public boolean isAfterOrEqual(ArtifactVersion v) {
            return this.isAfterOrEqual(v, 0);
        }

        public boolean isAfterOrEqual(ArtifactVersion v, int i) {
            if (i >= 3) {
                return true;
            }
            Integer local = this.versions[i];
            Integer target = v.versions[i];
            if (target == null) {
                return true;
            }
            if (local == null) {
                return false;
            }
            int compare = local.compareTo(target);
            return compare > 0 || compare == 0 && this.isAfterOrEqual(v, i + 1);
        }
    }
}

