/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.xml.web;

import com.google.common.collect.Iterables;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.xml.web.WebXmlCheckTemplate;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3369", name="Security constraints should be defined", priority=Priority.CRITICAL, tags={"cwe", "jee", "owasp-a7", "security", "websphere"})
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="3h")
public class SecurityConstraintsInWebXmlCheck
extends WebXmlCheckTemplate {
    private XPathExpression securityConstraintExpression;

    public void precompileXPathExpressions(XmlCheckContext context) {
        this.securityConstraintExpression = context.compile("web-app/security-constraint");
    }

    @Override
    public void scanWebXml(XmlCheckContext context) {
        if (this.hasNoSecurityConstraint(context)) {
            this.reportIssueOnFile("Add \"security-constraint\" elements to this descriptor.");
        }
    }

    private boolean hasNoSecurityConstraint(XmlCheckContext context) {
        return Iterables.isEmpty((Iterable)context.evaluateOnDocument(this.securityConstraintExpression));
    }
}

