/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1694", name="An abstract class should have both abstract and concrete methods", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class AbstractClassWithoutAbstractMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol typeSymbol = classTree.symbol();
        if (typeSymbol.isAbstract()) {
            Collection symbols = typeSymbol.memberSymbols();
            int abstractMethod = AbstractClassWithoutAbstractMethodCheck.countAbstractMethods(symbols);
            if (AbstractClassWithoutAbstractMethodCheck.isExtendingObject(classTree) && abstractMethod == symbols.size() - 2) {
                this.context.addIssue(tree, (JavaCheck)this, "Convert this \"" + typeSymbol + "\" class to an interface");
            }
            if (symbols.size() > 2 && abstractMethod == 0 && !AbstractClassWithoutAbstractMethodCheck.isPartialImplementation(classTree)) {
                this.context.addIssue(tree, (JavaCheck)this, "Convert this \"" + typeSymbol + "\" class to a concrete class with a private constructor");
            }
        }
    }

    private static boolean isExtendingObject(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        return superClass == null || superClass.symbolType().is("java.lang.Object");
    }

    private static boolean isPartialImplementation(ClassTree tree) {
        return tree.superClass() != null || !tree.superInterfaces().isEmpty();
    }

    private static int countAbstractMethods(Collection<? extends Symbol> symbols) {
        int abstractMethod = 0;
        for (Symbol symbol : symbols) {
            if (!AbstractClassWithoutAbstractMethodCheck.isAbstractMethod(symbol)) continue;
            ++abstractMethod;
        }
        return abstractMethod;
    }

    private static boolean isAbstractMethod(Symbol sym) {
        return sym.isMethodSymbol() && sym.isAbstract();
    }
}

