/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="AssignmentInSubExpressionCheck", name="Assignments should not be made from within sub-expressions", tags={"bug", "cwe", "misra"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class AssignmentInSubExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        this.scan((Tree)annotationTree.annotationType());
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        if (!lambdaExpressionTree.body().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            super.visitLambdaExpression(lambdaExpressionTree);
        }
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expressionTree = tree.expression();
        while (expressionTree instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)expressionTree;
            this.scan((Tree)assignmentExpressionTree.variable());
            expressionTree = assignmentExpressionTree.expression();
        }
        this.scan((Tree)expressionTree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (AssignmentInSubExpressionCheck.isRelationalExpression((Tree)tree)) {
            this.visitInnerExpression(tree.leftOperand());
            this.visitInnerExpression(tree.rightOperand());
        } else {
            super.visitBinaryExpression(tree);
        }
    }

    private void visitInnerExpression(ExpressionTree tree) {
        AssignmentExpressionTree assignmentExpressionTree = AssignmentInSubExpressionCheck.getInnerAssignmentExpression(tree);
        if (assignmentExpressionTree != null) {
            super.visitAssignmentExpression(assignmentExpressionTree);
        } else {
            this.scan((Tree)tree);
        }
    }

    @Nullable
    private static AssignmentExpressionTree getInnerAssignmentExpression(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            ParenthesizedTree parenthesizedTree = (ParenthesizedTree)tree;
            if (parenthesizedTree.expression().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                return (AssignmentExpressionTree)parenthesizedTree.expression();
            }
        }
        return null;
    }

    private static boolean isRelationalExpression(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}) || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}) || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO});
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.context.addIssue((Tree)tree, (JavaCheck)this, "Extract the assignment out of this expression.");
    }
}

