/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1066", name="Collapsible \"if\" statements should be merged", tags={"clumsy"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class CollapsibleIfCandidateCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<Boolean> outerIf = new ArrayDeque<Boolean>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitIfStatement(IfStatementTree tree) {
        if (!this.outerIf.isEmpty() && !CollapsibleIfCandidateCheck.hasElseClause(tree)) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Merge this if statement with the enclosing one.");
        }
        if (!CollapsibleIfCandidateCheck.hasElseClause(tree) && CollapsibleIfCandidateCheck.hasBodySingleIfStatement(tree.thenStatement())) {
            this.outerIf.push(Boolean.TRUE);
            super.visitIfStatement(tree);
            if (!this.outerIf.isEmpty()) {
                this.outerIf.pop();
            }
        } else {
            this.outerIf.clear();
            super.visitIfStatement(tree);
        }
    }

    private static boolean hasElseClause(IfStatementTree tree) {
        return tree.elseStatement() != null;
    }

    private static boolean hasBodySingleIfStatement(StatementTree thenStatement) {
        if (thenStatement.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)thenStatement;
            return block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT});
        }
        return thenStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT});
    }
}

