/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2070", name="SHA-1 and Message-Digest hash algorithms should not be used", tags={"cwe", "owasp-a6", "sans-top25-porous", "security"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="30min")
public class DeprecatedHashAlgorithmCheck
extends AbstractMethodDetection {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA-1";
    private static final Map<String, String> ALGORITHM_BY_METHOD_NAME = ImmutableMap.builder().put((Object)"getMd5Digest", (Object)"MD5").put((Object)"getShaDigest", (Object)"SHA-1").put((Object)"getSha1Digest", (Object)"SHA-1").put((Object)"md5", (Object)"MD5").put((Object)"md5Hex", (Object)"MD5").put((Object)"sha1", (Object)"SHA-1").put((Object)"sha1Hex", (Object)"SHA-1").put((Object)"sha", (Object)"SHA-1").put((Object)"shaHex", (Object)"SHA-1").build();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)MethodMatcher.create().typeDefinition("java.security.MessageDigest").name("getInstance").addParameter("java.lang.String")).add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name("getDigest").addParameter("java.lang.String"));
        for (String methodName : ALGORITHM_BY_METHOD_NAME.keySet()) {
            builder.add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name(methodName).withNoParameterConstraint());
        }
        for (String methodName : ImmutableList.of((Object)"md5", (Object)"sha1")) {
            builder.add((Object)MethodMatcher.create().typeDefinition("com.google.common.hash.Hashing").name(methodName));
        }
        return builder.build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = DeprecatedHashAlgorithmCheck.methodName(mit);
        String algorithm = ALGORITHM_BY_METHOD_NAME.get(methodName);
        if (algorithm == null) {
            Arguments arguments = mit.arguments();
            algorithm = DeprecatedHashAlgorithmCheck.algorithm((ExpressionTree)arguments.get(0));
        }
        if (MD5.equals(algorithm) || SHA1.equals(algorithm)) {
            this.addIssue((Tree)mit, "Use a stronger encryption algorithm than " + algorithm + ".");
        }
    }

    private static String methodName(MethodInvocationTree mit) {
        String name = null;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodSelect;
            name = memberSelectExpressionTree.identifier().name();
        } else if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)methodSelect;
            name = identifier.name();
        }
        return name;
    }

    private static String algorithm(ExpressionTree invocationArgument) {
        if (invocationArgument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return LiteralUtils.trimQuotes((String)((LiteralTree)invocationArgument).value());
        }
        return null;
    }
}

