/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1186", name="Methods should not be empty", tags={"bug"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class EmptyMethodsCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                this.checkMethod((MethodTree)member);
            }
        }
    }

    private void checkMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        if (block != null && EmptyMethodsCheck.isEmpty(block) && !EmptyMethodsCheck.containsComment(block)) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "Add a nested comment explaining why this method is empty, throw an UnsupportedOperationException or complete the implementation.");
        }
    }

    private static boolean isEmpty(BlockTree block) {
        List body = block.body();
        if (!body.isEmpty()) {
            for (StatementTree statementTree : body) {
                if (statementTree.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean containsComment(BlockTree block) {
        return !block.closeBraceToken().trivias().isEmpty();
    }
}

