/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1165", name="Exception classes should be immutable", tags={"error-handling", "security"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="15min")
public class ExceptionsShouldBeImmutableCheck
extends SubscriptionBaseVisitor {
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (ExceptionsShouldBeImmutableCheck.isException(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || ExceptionsShouldBeImmutableCheck.isFinal((VariableTree)member)) continue;
                this.addIssue(member, "Make this \"" + ((VariableTree)member).simpleName().name() + "\" field final.");
            }
        }
    }

    private static boolean isFinal(VariableTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.FINAL);
    }

    private static boolean isException(ClassTree classTree) {
        IdentifierTree simpleName = classTree.simpleName();
        return simpleName != null && (simpleName.name().endsWith("Exception") || simpleName.name().endsWith("Error"));
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }
}

