/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1067", name="Expressions should not be too complex", tags={"brain-overload"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="5min", effortToFixDescription="per complexity point above the threshold")
public class ExpressionComplexityCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(defaultValue="3", description="Maximum number of allowed conditional operators in an expression")
    public int max = 3;
    private final Deque<Integer> count = new LinkedList<Integer>();
    private final Deque<Integer> level = new LinkedList<Integer>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.count.clear();
        this.level.clear();
        this.level.push(0);
        this.count.push(0);
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.CLASS).add((Object)Tree.Kind.POSTFIX_INCREMENT).add((Object)Tree.Kind.POSTFIX_DECREMENT).add((Object)Tree.Kind.PREFIX_INCREMENT).add((Object)Tree.Kind.PREFIX_DECREMENT).add((Object)Tree.Kind.UNARY_PLUS).add((Object)Tree.Kind.UNARY_MINUS).add((Object)Tree.Kind.BITWISE_COMPLEMENT).add((Object)Tree.Kind.LOGICAL_COMPLEMENT).add((Object)Tree.Kind.MULTIPLY).add((Object)Tree.Kind.DIVIDE).add((Object)Tree.Kind.REMAINDER).add((Object)Tree.Kind.PLUS).add((Object)Tree.Kind.MINUS).add((Object)Tree.Kind.LEFT_SHIFT).add((Object)Tree.Kind.RIGHT_SHIFT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT).add((Object)Tree.Kind.LESS_THAN).add((Object)Tree.Kind.GREATER_THAN).add((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).add((Object)Tree.Kind.AND).add((Object)Tree.Kind.XOR).add((Object)Tree.Kind.OR).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).add((Object)Tree.Kind.CONDITIONAL_EXPRESSION).add((Object)Tree.Kind.ARRAY_ACCESS_EXPRESSION).add((Object)Tree.Kind.MEMBER_SELECT).add((Object)Tree.Kind.NEW_CLASS).add((Object)Tree.Kind.NEW_ARRAY).add((Object)Tree.Kind.METHOD_INVOCATION).add((Object)Tree.Kind.TYPE_CAST).add((Object)Tree.Kind.INSTANCE_OF).add((Object)Tree.Kind.PARENTHESIZED_EXPRESSION).add((Object)Tree.Kind.ASSIGNMENT).add((Object)Tree.Kind.MULTIPLY_ASSIGNMENT).add((Object)Tree.Kind.DIVIDE_ASSIGNMENT).add((Object)Tree.Kind.REMAINDER_ASSIGNMENT).add((Object)Tree.Kind.PLUS_ASSIGNMENT).add((Object)Tree.Kind.MINUS_ASSIGNMENT).add((Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.AND_ASSIGNMENT).add((Object)Tree.Kind.XOR_ASSIGNMENT).add((Object)Tree.Kind.OR_ASSIGNMENT).add((Object)Tree.Kind.INT_LITERAL).add((Object)Tree.Kind.LONG_LITERAL).add((Object)Tree.Kind.FLOAT_LITERAL).add((Object)Tree.Kind.DOUBLE_LITERAL).add((Object)Tree.Kind.BOOLEAN_LITERAL).add((Object)Tree.Kind.CHAR_LITERAL).add((Object)Tree.Kind.STRING_LITERAL).add((Object)Tree.Kind.NULL_LITERAL).add((Object)Tree.Kind.IDENTIFIER).add((Object)Tree.Kind.ARRAY_TYPE).add((Object)Tree.Kind.LAMBDA_EXPRESSION).add((Object)Tree.Kind.PRIMITIVE_TYPE).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || tree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            this.count.push(0);
            this.level.push(0);
        } else {
            if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR}) || tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND}) || tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
                this.count.push(this.count.pop() + 1);
            }
            this.level.push(this.level.pop() + 1);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || tree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            this.count.pop();
            this.level.pop();
        } else {
            int currentLevel = this.level.peek();
            if (currentLevel == 1) {
                int opCount = this.count.pop();
                if (opCount > this.max) {
                    this.addIssue(tree, "Reduce the number of conditional operators (" + opCount + ") used in the expression (maximum allowed " + this.max + ").", (double)opCount - (double)this.max);
                }
                this.count.push(0);
            }
            this.level.push(this.level.pop() - 1);
        }
    }
}

