/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1871", name="Two branches in the same conditional structure should not have exactly the same implementation", tags={"bug"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class IdenticalCasesInSwitchCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        int index = 0;
        List cases = switchStatementTree.cases();
        HashSet reportedLabels = Sets.newHashSet();
        for (CaseGroupTree caseGroupTree : cases) {
            for (int i = ++index; i < cases.size(); ++i) {
                CaseLabelTree labelToReport;
                if (!SyntacticEquivalence.areEquivalent((List)caseGroupTree.body(), (List)((CaseGroupTree)cases.get(i)).body()) || reportedLabels.contains(labelToReport = IdenticalCasesInSwitchCheck.getLastLabel((CaseGroupTree)cases.get(i)))) continue;
                reportedLabels.add(labelToReport);
                int line = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)caseGroupTree).line();
                this.addIssue((Tree)labelToReport, "Either merge this case with the identical one on line \"" + line + "\" or change one of the implementations.");
            }
        }
    }

    private static CaseLabelTree getLastLabel(CaseGroupTree cases) {
        return (CaseLabelTree)cases.labels().get(cases.labels().size() - 1);
    }
}

