/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2391", name="JUnit framework methods should be declared properly", tags={"bug", "junit"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="5min")
public class JunitMethodDeclarationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String JUNIT_SETUP = "setUp";
    private static final String JUNIT_TEARDOWN = "tearDown";
    private static final String JUNIT_SUITE = "suite";
    private static final int MAX_STRING_DISTANCE = 3;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (JunitMethodDeclarationCheck.isJunit3Class(tree)) {
            super.visitClass(tree);
        }
    }

    public void visitMethod(MethodTree methodTree) {
        String name = methodTree.simpleName().name();
        TypeTree returnType = methodTree.returnType();
        if (JUNIT_SETUP.equals(name)) {
            this.checkSetupTearDownSignature(methodTree);
        } else if (JUNIT_TEARDOWN.equals(name)) {
            this.checkSetupTearDownSignature(methodTree);
        } else if (JUNIT_SUITE.equals(name)) {
            this.checkSuiteSignature(methodTree);
        } else if (returnType != null && returnType.symbolType().isSubtypeOf("junit.framework.Test")) {
            this.addIssueForMethodBadName(methodTree, JUNIT_SUITE, name);
        } else if (this.areVerySimilarStrings(JUNIT_SETUP, name)) {
            this.addIssueForMethodBadName(methodTree, JUNIT_SETUP, name);
        } else if (this.areVerySimilarStrings(JUNIT_TEARDOWN, name)) {
            this.addIssueForMethodBadName(methodTree, JUNIT_TEARDOWN, name);
        } else if (this.areVerySimilarStrings(JUNIT_SUITE, name)) {
            this.addIssueForMethodBadName(methodTree, JUNIT_SUITE, name);
        }
    }

    @VisibleForTesting
    protected boolean areVerySimilarStrings(String expected, String actual) {
        return Math.abs(expected.length() - actual.length()) <= 3 && StringUtils.getLevenshteinDistance((String)expected, (String)actual) <= 3;
    }

    private void checkSuiteSignature(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        if (!symbol.isPublic()) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "Make this method \"public\".");
        } else if (!symbol.isStatic()) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "Make this method \"static\".");
        } else if (!methodTree.parameters().isEmpty()) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "This method does not accept parameters.");
        } else {
            TypeTree returnType = methodTree.returnType();
            if (returnType != null && !returnType.symbolType().isSubtypeOf("junit.framework.Test")) {
                this.context.addIssue((Tree)methodTree, (JavaCheck)this, "This method should return either a \"junit.framework.Test\" or a \"junit.framework.TestSuite\".");
            }
        }
    }

    private void checkSetupTearDownSignature(MethodTree methodTree) {
        Symbol.MethodSymbol symbol = methodTree.symbol();
        if (!symbol.isPublic()) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "Make this method \"public\".");
        } else if (!methodTree.parameters().isEmpty()) {
            this.context.addIssue((Tree)methodTree, (JavaCheck)this, "This method does not accept parameters.");
        } else {
            TypeTree returnType = methodTree.returnType();
            if (returnType != null && !returnType.symbolType().isVoid()) {
                this.context.addIssue((Tree)methodTree, (JavaCheck)this, "Make this method return \"void\".");
            }
        }
    }

    private void addIssueForMethodBadName(MethodTree methodTree, String expected, String actual) {
        this.context.addIssue((Tree)methodTree, (JavaCheck)this, "This method should be named \"" + expected + "\" not \"" + actual + "\".");
    }

    private static boolean isJunit3Class(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("junit.framework.TestCase");
    }
}

