/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1312", name="Loggers should be \"private static final\" and should share a naming convention", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class LoggersDeclarationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "LOG(?:GER)?";
    @RuleProperty(key="format", description="Regular expression used to check the logger names against.", defaultValue="LOG(?:GER)?")
    public String format = "LOG(?:GER)?";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    private static boolean isPrivateStaticFinal(ModifiersTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree, (Modifier)Modifier.PRIVATE) && ModifiersUtils.hasModifier((ModifiersTree)tree, (Modifier)Modifier.STATIC) && ModifiersUtils.hasModifier((ModifiersTree)tree, (Modifier)Modifier.FINAL);
    }

    private boolean isValidLoggerName(String name) {
        return this.pattern.matcher(name).matches();
    }

    public void visitMethod(MethodTree tree) {
        this.scan((Tree)tree.block());
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        if (LoggersDeclarationCheck.isLoggerType((Tree)tree.type())) {
            boolean isPrivateStaticFinal = LoggersDeclarationCheck.isPrivateStaticFinal(tree.modifiers());
            boolean hasValidLoggerName = this.isValidLoggerName(tree.simpleName().name());
            if (!isPrivateStaticFinal && !hasValidLoggerName) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, LoggersDeclarationCheck.getPrivateStaticFinalMessage(tree.simpleName().name()) + " and rename it to comply with the format \"" + this.format + "\".");
            } else if (!isPrivateStaticFinal) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, LoggersDeclarationCheck.getPrivateStaticFinalMessage(tree.simpleName().name()) + ".");
            } else if (!hasValidLoggerName) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, "Rename the \"" + tree.simpleName() + "\" logger to comply with the format \"" + this.format + "\".");
            }
        }
    }

    private static String getPrivateStaticFinalMessage(String simpleName) {
        return "Make the \"" + simpleName + "\" logger private static final";
    }

    private static boolean isLoggerType(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return false;
        }
        IdentifierTree identifierTree = (IdentifierTree)tree;
        return "Log".equals(identifierTree.name()) || "Logger".equals(identifierTree.name());
    }
}

