/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2384", name="Mutable members should not be stored or returned directly", tags={"cert", "cwe", "security", "unpredictable"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class MutableMembersUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final List<String> MUTABLE_TYPES = ImmutableList.of((Object)"java.util.Collection", (Object)"java.util.Date", (Object)"java.util.Hashtable");
    private static final List<String> IMMUTABLE_TYPES = ImmutableList.of((Object)"java.util.Collections.UnmodifiableCollection", (Object)"java.util.Collections.UnmodifiableMap", (Object)"com.google.common.collect.ImmutableCollection");
    private JavaFileScannerContext context;
    private Deque<List<Symbol>> parametersStack = new LinkedList<List<Symbol>>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        ArrayList<Symbol> parameters = new ArrayList<Symbol>();
        for (VariableTree variableTree : tree.parameters()) {
            parameters.add(variableTree.symbol());
        }
        this.parametersStack.push(parameters);
        super.visitMethod(tree);
        this.parametersStack.pop();
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        if (!MutableMembersUsageCheck.isMutableType(tree.expression().symbolType())) {
            return;
        }
        ExpressionTree variable = tree.variable();
        Symbol leftSymbol = null;
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifierTree = (IdentifierTree)variable;
            leftSymbol = identifierTree.symbol();
        } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mit = (MemberSelectExpressionTree)variable;
            leftSymbol = mit.identifier().symbol();
        }
        if (leftSymbol != null && leftSymbol.isPrivate()) {
            this.checkStore(tree.expression());
        }
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        ExpressionTree initializer = tree.initializer();
        if (initializer == null || !MutableMembersUsageCheck.isMutableType(initializer.symbolType())) {
            return;
        }
        this.checkStore(initializer);
    }

    private void checkStore(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree identifierTree = (IdentifierTree)expression;
            if (!this.parametersStack.isEmpty() && this.parametersStack.peek().contains(identifierTree.symbol())) {
                this.context.addIssue((Tree)expression, (JavaCheck)this, "Store a copy of \"" + identifierTree.name() + "\".");
            }
        }
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        IdentifierTree identifierTree;
        super.visitReturnStatement(tree);
        ExpressionTree expressionTree = tree.expression();
        if (expressionTree == null || !MutableMembersUsageCheck.isMutableType(expressionTree.symbolType())) {
            return;
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (identifierTree = (IdentifierTree)expressionTree).symbol().isPrivate()) {
            this.context.addIssue((Tree)expressionTree, (JavaCheck)this, "Return a copy of \"" + identifierTree.name() + "\".");
        }
    }

    private static boolean isMutableType(Type type) {
        if (type.isArray()) {
            return true;
        }
        for (String mutableType : MUTABLE_TYPES) {
            if (!type.isSubtypeOf(mutableType) || !MutableMembersUsageCheck.isNotImmutable(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotImmutable(Type type) {
        for (String immutableType : IMMUTABLE_TYPES) {
            if (!type.isSubtypeOf(immutableType)) continue;
            return false;
        }
        return true;
    }
}

