/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1174", name="\"Object.finalize()\" should remain protected (versus public) when overriding", tags={"cert", "cwe", "security"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class ObjectFinalizeOverridenNotPublicCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (ObjectFinalizeOverridenNotPublicCheck.isFinalize(methodTree) && ObjectFinalizeOverridenNotPublicCheck.isPublic(methodTree)) {
            this.addIssue((Tree)methodTree.simpleName(), "Make this finalize() method protected.");
        }
    }

    private static boolean isPublic(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PUBLIC);
    }

    private static boolean isFinalize(MethodTree methodTree) {
        TypeTree returnType;
        if ("finalize".equals(methodTree.simpleName().name()) && (returnType = methodTree.returnType()) != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE})) {
            return "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }
}

