/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2245", name="Pseudorandom number generators (PRNGs) should not be used in secure contexts", tags={"cert", "cwe", "owasp-a6", "security"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="10min")
public class PseudoRandomCheck
extends SubscriptionBaseVisitor {
    private MethodMatcher methodInvocationMatcher = MethodMatcher.create().typeDefinition("java.lang.Math").name("random");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.isMathRandom(tree) || PseudoRandomCheck.isJavaUtilRandom((ExpressionTree)tree)) {
            this.addIssue(tree, "Use a cryptographically strong random number generator (RNG) like \"java.security.SecureRandom\" in place of this PRNG");
        }
    }

    private boolean isMathRandom(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && this.hasSemantic() && this.methodInvocationMatcher.matches((MethodInvocationTree)tree);
    }

    private static boolean isJavaUtilRandom(ExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && tree.symbolType().is("java.util.Random");
    }
}

