/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInjectionChecker;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2077", name="Values passed to SQL commands should be sanitized", tags={"cwe", "owasp-a1", "sans-top25-insecure", "security", "sql", "hibernate"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INPUT_VALIDATION_AND_REPRESENTATION")
@SqaleConstantRemediation(value="20min")
public class SQLInjectionCheck
extends AbstractInjectionChecker {
    public void visitNode(Tree tree) {
        MethodInvocationTree methodTree = (MethodInvocationTree)tree;
        boolean isHibernateCall = SQLInjectionCheck.isHibernateCall(methodTree);
        if (SQLInjectionCheck.isHibernateCall(methodTree) || SQLInjectionCheck.isExecuteQueryOrPrepareStatement(methodTree)) {
            ExpressionTree arg = (ExpressionTree)methodTree.arguments().get(0);
            this.parameterName = "";
            if (this.isDynamicString((Tree)methodTree, arg, null, true)) {
                String message = "\"" + this.parameterName + "\" is provided externally to the method and not sanitized before use.";
                if (isHibernateCall) {
                    message = "Use Hibernate's parameter binding instead of concatenation.";
                }
                this.addIssue((Tree)methodTree, message);
            }
        }
    }

    private static boolean isExecuteQueryOrPrepareStatement(MethodInvocationTree methodTree) {
        if (methodTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodTree.methodSelect();
            return !methodTree.arguments().isEmpty() && (SQLInjectionCheck.isMethodCall("java.sql.Statement", "executeQuery", memberSelectExpressionTree) || SQLInjectionCheck.isMethodCall("java.sql.Connection", "prepareStatement", memberSelectExpressionTree) || SQLInjectionCheck.isMethodCall("java.sql.Connection", "prepareCall", memberSelectExpressionTree));
        }
        return false;
    }

    private static boolean isHibernateCall(MethodInvocationTree methodTree) {
        if (methodTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodTree.methodSelect();
            return !methodTree.arguments().isEmpty() && SQLInjectionCheck.isMethodCall("org.hibernate.Session", "createQuery", memberSelectExpressionTree);
        }
        return false;
    }

    private static boolean isMethodCall(String typeName, String methodName, MemberSelectExpressionTree memberSelectExpressionTree) {
        return methodName.equals(memberSelectExpressionTree.identifier().name()) && SQLInjectionCheck.isInvokedOnType(typeName, memberSelectExpressionTree.expression());
    }

    private static boolean isInvokedOnType(String type, ExpressionTree expressionTree) {
        Type selectorType = expressionTree.symbolType();
        if (selectorType.isClass()) {
            return type.equals(selectorType.fullyQualifiedName()) || SQLInjectionCheck.checkInterfaces(type, selectorType.symbol());
        }
        return false;
    }

    private static boolean checkInterfaces(String type, Symbol.TypeSymbol symbol) {
        for (Type interfaceType : symbol.interfaces()) {
            if (!type.equals(interfaceType.fullyQualifiedName()) && !SQLInjectionCheck.checkInterfaces(type, interfaceType.symbol())) continue;
            return true;
        }
        return false;
    }
}

