/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2130", name="Parsing should be used to convert \"Strings\" to primitives", tags={"performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class StringToPrimitiveConversionCheck
extends SubscriptionBaseVisitor {
    private final List<PrimitiveCheck> primitiveChecks = this.buildPrimitiveChecks();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTreeImpl variableTree = (VariableTreeImpl)tree;
                Type variableType = variableTree.type().symbolType();
                PrimitiveCheck primitiveCheck = this.getPrimitiveCheck(variableType);
                ExpressionTree initializer = variableTree.initializer();
                if (primitiveCheck != null && initializer != null) {
                    primitiveCheck.checkInstanciation(initializer);
                }
            } else {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                for (PrimitiveCheck primitiveCheck : this.primitiveChecks) {
                    primitiveCheck.checkMethodInvocation(methodInvocationTree);
                }
            }
        }
    }

    private PrimitiveCheck getPrimitiveCheck(Type type) {
        if (!type.isPrimitive()) {
            return null;
        }
        for (PrimitiveCheck primitiveCheck : this.primitiveChecks) {
            if (!type.isPrimitive(primitiveCheck.tag)) continue;
            return primitiveCheck;
        }
        return null;
    }

    private List<PrimitiveCheck> buildPrimitiveChecks() {
        return ImmutableList.of((Object)new PrimitiveCheck("int", "Integer", Type.Primitives.INT), (Object)new PrimitiveCheck("boolean", "Boolean", Type.Primitives.BOOLEAN), (Object)new PrimitiveCheck("byte", "Byte", Type.Primitives.BYTE), (Object)new PrimitiveCheck("double", "Double", Type.Primitives.DOUBLE), (Object)new PrimitiveCheck("float", "Float", Type.Primitives.FLOAT), (Object)new PrimitiveCheck("long", "Long", Type.Primitives.LONG), (Object)new PrimitiveCheck("short", "Short", Type.Primitives.SHORT));
    }

    private class PrimitiveCheck {
        private final String primitiveName;
        private final String className;
        private final Type.Primitives tag;
        private final String message;
        private final MethodMatcher unboxingInvocationMatcher;
        private final MethodMatcher valueOfInvocationMatcher;

        private PrimitiveCheck(String primitiveName, String className, Type.Primitives tag) {
            this.primitiveName = primitiveName;
            this.className = className;
            this.tag = tag;
            this.message = "Use \"" + this.parseMethodName() + "\" for this string-to-" + primitiveName + " conversion.";
            this.unboxingInvocationMatcher = MethodMatcher.create().typeDefinition("java.lang." + className).name(primitiveName + "Value");
            this.valueOfInvocationMatcher = MethodMatcher.create().typeDefinition("java.lang." + className).name("valueOf").addParameter("java.lang.String");
        }

        private void checkMethodInvocation(MethodInvocationTree methodInvocationTree) {
            if (this.unboxingInvocationMatcher.matches(methodInvocationTree)) {
                MemberSelectExpressionTree methodSelect = (MemberSelectExpressionTree)methodInvocationTree.methodSelect();
                this.checkInstanciation(methodSelect.expression());
            }
        }

        private void checkInstanciation(ExpressionTree expression) {
            if (this.isBadlyInstanciated(expression)) {
                StringToPrimitiveConversionCheck.this.addIssue((Tree)expression, this.message);
            }
        }

        private boolean isBadlyInstanciated(ExpressionTree expression) {
            IdentifierTree identifier;
            Symbol reference;
            boolean result = false;
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                result = this.isStringBasedConstructor((NewClassTree)expression);
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                result = this.valueOfInvocationMatcher.matches((MethodInvocationTree)expression);
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (reference = (identifier = (IdentifierTree)expression).symbol()).isVariableSymbol() && reference.usages().size() == 1) {
                Symbol.VariableSymbol variableSymbol = (Symbol.VariableSymbol)reference;
                result = this.isBadlyInstanciatedVariable(variableSymbol);
            }
            return result;
        }

        private boolean isBadlyInstanciatedVariable(Symbol.VariableSymbol variableSymbol) {
            ExpressionTree initializer;
            VariableTree variableTree = variableSymbol.declaration();
            if (variableTree != null && (initializer = variableTree.initializer()) != null) {
                return this.isBadlyInstanciated(initializer);
            }
            return false;
        }

        private boolean isStringBasedConstructor(NewClassTree newClassTree) {
            Arguments arguments = newClassTree.arguments();
            return ((ExpressionTree)arguments.get(0)).symbolType().is("java.lang.String");
        }

        private String parseMethodName() {
            return this.className + ".parse" + StringUtils.capitalize((String)this.primitiveName);
        }
    }
}

