/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1858", name="\"toString()\" should never be called on a String object", tags={"clumsy", "pitfall"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class StringToStringCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.lang.String").name("toString"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        ExpressionTree expressionTree = StringToStringCheck.extractBaseExpression(((MemberSelectExpressionTree)tree.methodSelect()).expression());
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.addIssue((Tree)expressionTree, String.format("\"%s\" is already a string, there's no need to call \"toString()\" on it.", ((IdentifierTree)expressionTree).identifierToken().text()));
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.addIssue((Tree)expressionTree, "there's no need to call \"toString()\" on a string literal.");
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.addIssue((Tree)expressionTree, String.format("\"%s\" returns a string, there's no need to call \"toString()\".", StringToStringCheck.extractName(((MethodInvocationTree)expressionTree).methodSelect())));
        } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
            String name = StringToStringCheck.extractName(((ArrayAccessExpressionTree)expressionTree).expression());
            if (name.isEmpty()) {
                this.addIssue((Tree)expressionTree, "There's no need to call \"toString()\" on an array of String.");
            } else {
                this.addIssue((Tree)expressionTree, String.format("\"%s\" is an array of strings, there's no need to call \"toString()\".", name));
            }
        }
    }

    private static ExpressionTree extractBaseExpression(ExpressionTree tree) {
        ExpressionTree expressionTree = tree;
        while (true) {
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                expressionTree = ((MemberSelectExpressionTree)expressionTree).identifier();
                continue;
            }
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
                expressionTree = ((ParenthesizedTree)expressionTree).expression();
                continue;
            }
            if (!expressionTree.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) break;
            expressionTree = ((TypeCastTree)expressionTree).expression();
        }
        return expressionTree;
    }

    private static String extractName(ExpressionTree tree) {
        ExpressionTree expressionTree = StringToStringCheck.extractBaseExpression(tree);
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)expressionTree).identifierToken().text();
        }
        return "";
    }
}

