/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1149", name="Synchronized classes Vector, Hashtable, Stack and StringBuffer should not be used", tags={"multi-threading", "performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="20min")
public class SynchronizedClassUsageCheck
extends SubscriptionBaseVisitor {
    private static final Map<String, String> REPLACEMENTS = ImmutableMap.builder().put((Object)"java.util.Vector", (Object)"\"ArrayList\" or \"LinkedList\"").put((Object)"java.util.Hashtable", (Object)"\"HashMap\"").put((Object)"java.lang.StringBuffer", (Object)"\"StringBuilder\"").put((Object)"java.util.Stack", (Object)"\"Deque\"").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        tree.accept((TreeVisitor)new DeprecatedTypeVisitor());
    }

    private static boolean isDeprecatedType(Type symbolType) {
        if (symbolType.isClass()) {
            for (String deprecatedType : REPLACEMENTS.keySet()) {
                if (!symbolType.is(deprecatedType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOverriding(MethodTree tree) {
        return BooleanUtils.isTrue((Boolean)((MethodTreeImpl)tree).isOverriding());
    }

    private class DeprecatedTypeVisitor
    extends BaseTreeVisitor {
        private DeprecatedTypeVisitor() {
        }

        public void visitClass(ClassTree tree) {
            TypeTree superClass = tree.superClass();
            if (superClass != null) {
                this.reportIssueOnDeprecatedType((Tree)tree, superClass.symbolType());
            }
            this.scan(tree.members());
        }

        public void visitMethod(MethodTree tree) {
            TypeTree returnTypeTree = tree.returnType();
            if (!SynchronizedClassUsageCheck.isOverriding(tree) || returnTypeTree == null) {
                if (returnTypeTree != null) {
                    this.reportIssueOnDeprecatedType((Tree)returnTypeTree, returnTypeTree.symbolType());
                }
                this.scan(tree.parameters());
            }
            this.scan((Tree)tree.block());
        }

        public void visitVariable(VariableTree tree) {
            ExpressionTree initializer = tree.initializer();
            if (!this.reportIssueOnDeprecatedType((Tree)tree.type(), tree.symbol().type()) && initializer != null && !initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.reportIssueOnDeprecatedType((Tree)initializer, initializer.symbolType());
            }
        }

        private boolean reportIssueOnDeprecatedType(Tree tree, Type type) {
            if (SynchronizedClassUsageCheck.isDeprecatedType(type)) {
                SynchronizedClassUsageCheck.this.addIssue(tree, "Replace the synchronized class \"" + type.name() + "\" by an unsynchronized one such as " + (String)REPLACEMENTS.get(type.fullyQualifiedName()) + ".");
                return true;
            }
            return false;
        }
    }
}

