/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2230", name="Non-public methods should not be \"@Transactional\"", tags={"bug", "spring"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class TransactionalMethodVisibilityCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree method = (MethodTree)tree;
        boolean isPublic = method.modifiers().contains((Object)Modifier.PUBLIC);
        if (this.hasSemantic()) {
            isPublic = method.symbol().isPublic();
        }
        if (!isPublic && TransactionalMethodVisibilityCheck.hasTransactionalAnnotation(method)) {
            this.addIssue((Tree)method, "Make this method \"public\" or remove the \"@Transactional\" annotation");
        }
    }

    private static boolean hasTransactionalAnnotation(MethodTree method) {
        for (AnnotationTree annotation : method.modifiers().annotations()) {
            if (!annotation.symbolType().is("org.springframework.transaction.annotation.Transactional")) continue;
            return true;
        }
        return false;
    }
}

