/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.closeresource;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.closeresource.CloseableState;
import org.sonar.java.symexecengine.ExecutionState;
import org.sonar.java.symexecengine.State;
import org.sonar.java.symexecengine.SymbolicExecutionCheck;
import org.sonar.java.symexecengine.SymbolicValue;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;

public class CloseableVisitor
extends SymbolicExecutionCheck {
    private static final String CLOSE_METHOD_NAME = "close";
    private static final String JAVA_IO_CLOSEABLE = "java.io.Closeable";
    private static final String JAVA_LANG_AUTOCLOSEABLE = "java.lang.AutoCloseable";
    private static final MethodInvocationMatcherCollection CLOSE_INVOCATIONS = MethodInvocationMatcherCollection.create(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.io.Closeable")).name("close").withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.AutoCloseable")).name("close").withNoParameterConstraint(), MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("org.springframework.context.support.AbstractApplicationContext")).name("registerShutdownHook").withNoParameterConstraint());
    private static final String[] IGNORED_CLOSEABLE_SUBTYPES = new String[]{"java.io.ByteArrayOutputStream", "java.io.ByteArrayInputStream", "java.io.StringReader", "java.io.StringWriter", "java.io.CharArrayReader", "java.io.CharArrayWriter"};
    private final Set<Tree> issueTree = new HashSet<Tree>();

    @Override
    protected void initialize(ExecutionState executionState, MethodTree tree, List<SymbolicValue> arguments) {
        for (SymbolicValue argument : arguments) {
            CloseableVisitor.ignoreValue(executionState, argument);
        }
    }

    private static void ignoreValue(ExecutionState executionState, SymbolicValue value) {
        executionState.markValueAs(value, (State)new CloseableState.Ignored(value.getTree()));
    }

    private static boolean isCloseableOrAutoCloseableSubtype(Type type) {
        return type.isSubtypeOf(JAVA_IO_CLOSEABLE) || type.isSubtypeOf(JAVA_LANG_AUTOCLOSEABLE);
    }

    private static boolean isIgnoredCloseableSubtype(Type type) {
        for (String fullyQualifiedName : IGNORED_CLOSEABLE_SUBTYPES) {
            if (!type.isSubtypeOf(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubclassOfInputStreamOrOutputStreamWithoutClose(Type type) {
        Symbol.TypeSymbol typeSymbol = type.symbol();
        Type superClass = typeSymbol.superClass();
        if (superClass != null && (superClass.is("java.io.OutputStream") || superClass.is("java.io.InputStream"))) {
            return typeSymbol.lookupSymbols(CLOSE_METHOD_NAME).isEmpty();
        }
        return false;
    }

    @Override
    protected void onAssignment(ExecutionState executionState, Tree tree, Symbol variable, ExpressionTree expression) {
        CloseableVisitor.ignoreClosableSymbols(executionState, expression);
        if ((tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || CloseableVisitor.isVariableIdentifierOrMemberSelect((AssignmentExpressionTree)tree)) && CloseableVisitor.isCloseableOrAutoCloseableSubtype(variable.type())) {
            executionState.markValueAs(variable, CloseableVisitor.getCloseableStateFromExpression(executionState, variable, expression));
        }
    }

    private static boolean isVariableIdentifierOrMemberSelect(AssignmentExpressionTree tree) {
        return tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT});
    }

    private static State getCloseableStateFromExpression(ExecutionState executionState, Symbol symbol, @Nullable ExpressionTree expression) {
        if (CloseableVisitor.shouldBeIgnored(executionState, symbol, expression)) {
            return new CloseableState.Ignored((Tree)expression);
        }
        if (CloseableVisitor.isNull(expression)) {
            return State.UNSET;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            if (CloseableVisitor.usesIgnoredCloseableAsArgument(executionState, (List<ExpressionTree>)((NewClassTree)expression).arguments())) {
                return new CloseableState.Ignored((Tree)expression);
            }
            return new CloseableState.Open((Tree)expression);
        }
        return new CloseableState.Ignored((Tree)expression);
    }

    private static boolean isNull(ExpressionTree expression) {
        return expression == null || expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
    }

    private static boolean shouldBeIgnored(ExecutionState executionState, Symbol symbol, @Nullable ExpressionTree expression) {
        return CloseableVisitor.shouldBeIgnored(executionState, symbol) || CloseableVisitor.shouldBeIgnored(expression);
    }

    private static boolean shouldBeIgnored(ExecutionState executionState, Symbol symbol) {
        return CloseableVisitor.isSymbolIgnored(executionState, symbol) || symbol.isFinal() || CloseableVisitor.isIgnoredCloseableSubtype(symbol.type()) || CloseableVisitor.isSubclassOfInputStreamOrOutputStreamWithoutClose(symbol.type());
    }

    private static boolean shouldBeIgnored(@Nullable ExpressionTree expression) {
        return expression != null && (CloseableVisitor.isSubclassOfInputStreamOrOutputStreamWithoutClose(expression.symbolType()) || CloseableVisitor.isIgnoredCloseableSubtype(expression.symbolType()));
    }

    private static boolean usesIgnoredCloseableAsArgument(ExecutionState executionState, List<ExpressionTree> arguments) {
        for (ExpressionTree argument : arguments) {
            if (CloseableVisitor.isNewClassWithIgnoredArguments(executionState, argument)) {
                return true;
            }
            if (CloseableVisitor.isMethodInvocationWithIgnoredArguments(executionState, argument)) {
                return true;
            }
            if (!CloseableVisitor.useIgnoredCloseable(executionState, argument) && !CloseableVisitor.isSubclassOfInputStreamOrOutputStreamWithoutClose(argument.symbolType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNewClassWithIgnoredArguments(ExecutionState executionState, ExpressionTree argument) {
        return argument.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && CloseableVisitor.usesIgnoredCloseableAsArgument(executionState, (List<ExpressionTree>)((NewClassTree)argument).arguments());
    }

    private static boolean isMethodInvocationWithIgnoredArguments(ExecutionState executionState, ExpressionTree argument) {
        return argument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && CloseableVisitor.usesIgnoredCloseableAsArgument(executionState, (List<ExpressionTree>)((MethodInvocationTree)argument).arguments());
    }

    private static boolean useIgnoredCloseable(ExecutionState executionState, ExpressionTree expression) {
        IdentifierTree identifier;
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT}) && CloseableVisitor.isIgnoredCloseable(executionState, (identifier = expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)expression).identifier() : (IdentifierTree)expression).symbol());
    }

    private static boolean isIgnoredCloseable(ExecutionState executionState, Symbol symbol) {
        if (CloseableVisitor.isCloseableOrAutoCloseableSubtype(symbol.type()) && !symbol.owner().isMethodSymbol()) {
            return true;
        }
        return CloseableVisitor.isSymbolIgnored(executionState, symbol);
    }

    private static boolean isSymbolIgnored(ExecutionState executionState, Symbol symbol) {
        List<State> statesOf = executionState.getStatesOf(symbol);
        for (State state : statesOf) {
            if (!(state instanceof CloseableState) || !((CloseableState)state).isIgnored()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onTryResourceClosed(ExecutionState executionState, SymbolicValue resource) {
        CloseableVisitor.ignoreValue(executionState, resource);
    }

    @Override
    protected void onValueReturned(ExecutionState executionState, ReturnStatementTree tree, ExpressionTree expression) {
        CloseableVisitor.ignoreClosableSymbols(executionState, expression);
    }

    @Override
    protected void onExecutableElementInvocation(ExecutionState executionState, Tree tree, List<ExpressionTree> arguments) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            CloseableVisitor.ignoreClosableSymbols(executionState, (List<ExpressionTree>)((NewClassTree)tree).arguments());
        } else {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)tree;
            if (CLOSE_INVOCATIONS.anyMatch(methodInvocation)) {
                ExpressionTree methodSelect = methodInvocation.methodSelect();
                if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                    if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                        executionState.markValueAs(((IdentifierTree)expression).symbol(), (State)new CloseableState.Closed((Tree)expression));
                    }
                }
            } else {
                CloseableVisitor.ignoreClosableSymbols(executionState, (List<ExpressionTree>)methodInvocation.arguments());
            }
        }
    }

    private static void ignoreClosableSymbols(ExecutionState executionState, List<ExpressionTree> expressions) {
        for (ExpressionTree expression : expressions) {
            CloseableVisitor.ignoreClosableSymbols(executionState, expression);
        }
    }

    private static void ignoreClosableSymbols(ExecutionState executionState, @Nullable ExpressionTree expression) {
        if (expression != null) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && CloseableVisitor.isCloseableOrAutoCloseableSubtype(expression.symbolType())) {
                executionState.markValueAs(((IdentifierTree)expression).symbol(), (State)new CloseableState.Ignored((Tree)expression));
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                CloseableVisitor.ignoreClosableSymbols(executionState, (ExpressionTree)((MemberSelectExpressionTree)expression).identifier());
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
                CloseableVisitor.ignoreClosableSymbols(executionState, ((TypeCastTree)expression).expression());
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                CloseableVisitor.ignoreClosableSymbols(executionState, (List<ExpressionTree>)((MethodInvocationTree)expression).arguments());
            } else if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                CloseableVisitor.ignoreClosableSymbols(executionState, (List<ExpressionTree>)((NewClassTree)expression).arguments());
            }
        }
    }

    @Override
    protected void onValueUnreachable(ExecutionState executionState, State state) {
        if (state instanceof CloseableState.Open) {
            this.issueTree.addAll(state.reportingTrees());
        }
    }

    public Set<Tree> getIssueTrees() {
        return this.issueTree;
    }
}

