/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.symexec;

import com.google.common.base.Preconditions;
import org.sonar.plugins.java.api.semantic.Symbol;

abstract class SymbolicValue {
    static final SymbolicBooleanValue BOOLEAN_TRUE = new SymbolicBooleanValue();

    private SymbolicValue() {
    }

    static final class SymbolicVariableValue
    extends SymbolicValue {
        final Symbol.VariableSymbol variable;

        SymbolicVariableValue(Symbol.VariableSymbol variable) {
            Preconditions.checkNotNull((Object)variable);
            this.variable = variable;
        }

        public boolean equals(Object that) {
            return that instanceof SymbolicVariableValue && this.variable.equals(((SymbolicVariableValue)that).variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }
    }

    static final class SymbolicLongValue
    extends SymbolicValue {
        final long value;

        SymbolicLongValue(long value) {
            this.value = value;
        }

        public boolean equals(Object that) {
            return that instanceof SymbolicLongValue && this.value == ((SymbolicLongValue)that).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    static final class SymbolicBooleanValue
    extends SymbolicValue {
        SymbolicBooleanValue() {
        }
    }
}

