/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.closeresource.CloseableVisitor;
import org.sonar.java.symexecengine.DataFlowVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2095", name="Resources should be closed", tags={"bug", "cert", "cwe", "denial-of-service", "leak", "security"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class CloseResourceCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        CloseableVisitor visitor = new CloseableVisitor();
        DataFlowVisitor.analyze((MethodTree)tree, visitor);
        for (Tree issueTree : visitor.getIssueTrees()) {
            Type reportedType = null;
            if (issueTree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                reportedType = ((NewClassTree)issueTree).symbolType();
            }
            if (reportedType == null) continue;
            this.addIssue(issueTree, String.format("Close this \"%s\".", reportedType.name()));
        }
    }
}

