/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2175", name="Inappropriate \"Collection\" calls should not be made", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class CollectionInappropriateCallsCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)CollectionInappropriateCallsCheck.collectionMethodInvocation("remove"), (Object)CollectionInappropriateCallsCheck.collectionMethodInvocation("contains"));
    }

    private static MethodMatcher collectionMethodInvocation(String methodName) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.util.Collection")).name(methodName).addParameter("java.lang.Object");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        Type argumentType = ((ExpressionTree)tree.arguments().get(0)).symbolType();
        Type collectionType = CollectionInappropriateCallsCheck.getMethodOwner(tree);
        Type collectionParameterType = CollectionInappropriateCallsCheck.getTypeParameter(collectionType);
        if (collectionParameterType != null && !collectionParameterType.isUnknown() && !CollectionInappropriateCallsCheck.isArgumentCompatible(argumentType, collectionParameterType)) {
            this.addIssue((Tree)tree, MessageFormat.format("A \"{0}<{1}>\" cannot contain a \"{2}\"", collectionType, collectionParameterType, argumentType));
        }
    }

    private static Type getMethodOwner(MethodInvocationTree mit) {
        if (mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)mit.methodSelect()).expression().symbolType();
        }
        return mit.symbol().owner().type();
    }

    @Nullable
    private static Type getTypeParameter(Type collectionType) {
        if (collectionType instanceof JavaType.ParametrizedTypeJavaType) {
            return CollectionInappropriateCallsCheck.getFirstTypeParameter((JavaType.ParametrizedTypeJavaType)collectionType);
        }
        return null;
    }

    @Nullable
    private static Type getFirstTypeParameter(JavaType.ParametrizedTypeJavaType parametrizedTypeType) {
        Iterator i$ = parametrizedTypeType.typeParameters().iterator();
        if (i$.hasNext()) {
            JavaType.TypeVariableJavaType variableType = (JavaType.TypeVariableJavaType)i$.next();
            return parametrizedTypeType.substitution(variableType);
        }
        return null;
    }

    private static boolean isArgumentCompatible(Type argumentType, Type collectionParameterType) {
        return CollectionInappropriateCallsCheck.isSubtypeOf(argumentType.erasure(), collectionParameterType.erasure()) || CollectionInappropriateCallsCheck.isSubtypeOf(collectionParameterType.erasure(), argumentType.erasure()) || CollectionInappropriateCallsCheck.autoboxing(argumentType, collectionParameterType);
    }

    private static boolean isSubtypeOf(Type type, Type superType) {
        return type.isSubtypeOf(superType);
    }

    private static boolean autoboxing(Type argumentType, Type collectionParameterType) {
        return argumentType.isPrimitive() && ((JavaType)collectionParameterType).isPrimitiveWrapper() && CollectionInappropriateCallsCheck.isSubtypeOf((Type)((JavaType)argumentType).primitiveWrapperType(), collectionParameterType);
    }
}

