/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1862", name="Related \"if/else if\" statements should not have the same condition", tags={"bug", "cert", "pitfall", "unused"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class DuplicateConditionIfElseIfCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition();
        StatementTree statement = tree.elseStatement();
        while (statement != null && statement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)statement;
            if (SyntacticEquivalence.areEquivalent((Tree)condition, (Tree)ifStatement.condition())) {
                this.context.addIssue((Tree)ifStatement.condition(), (JavaCheck)this, "This branch can not be reached because the condition duplicates a previous condition in the same sequence of \"if/else if\" statements");
            }
            statement = ifStatement.elseStatement();
        }
        super.visitIfStatement(tree);
    }
}

