/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1215", name="Execution of the Garbage Collector should be triggered only by the JVM", tags={"unpredictable"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class GarbageCollectorCalledCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MemberSelectExpressionTree mset;
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (mit.arguments().isEmpty() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && GarbageCollectorCalledCheck.isGarbageCollectorCall(mset = (MemberSelectExpressionTree)mit.methodSelect())) {
            this.addIssue(tree, "Don't try to be smarter than the JVM, remove this call to run the garbage collector.");
        }
    }

    private static boolean isGarbageCollectorCall(MemberSelectExpressionTree mset) {
        if ("gc".equals(mset.identifier().name())) {
            MethodInvocationTree mit;
            if (mset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return "System".equals(((IdentifierTree)mset.expression()).name());
            }
            if (mset.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (mit = (MethodInvocationTree)mset.expression()).arguments().isEmpty() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree subMset = (MemberSelectExpressionTree)mit.methodSelect();
                return "getRuntime".equals(subMset.identifier().name()) && subMset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "Runtime".equals(((IdentifierTree)subMset.expression()).name());
            }
        }
        return false;
    }
}

