/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2674", name="The value returned from a stream read should be checked", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class IgnoredStreamReturnValueCheck
extends SubscriptionBaseVisitor {
    private static final MethodInvocationMatcherCollection MATCHERS = MethodInvocationMatcherCollection.create(IgnoredStreamReturnValueCheck.inputStreamInvocationMatcher("skip", "long"), IgnoredStreamReturnValueCheck.inputStreamInvocationMatcher("read", "byte[]"));

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit;
        if (!this.hasSemantic()) {
            return;
        }
        ExpressionTree statement = ((ExpressionStatementTree)tree).expression();
        if (statement.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && MATCHERS.anyMatch(mit = (MethodInvocationTree)statement)) {
            this.addIssue((Tree)mit, "Check the return value of the \"" + mit.symbol().name() + "\" call to see how many bytes were read.");
        }
    }

    private static MethodMatcher inputStreamInvocationMatcher(String methodName, String parameterType) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.io.InputStream")).name(methodName).addParameter(parameterType);
    }
}

