/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1193", name="Exception types should not be tested using \"instanceof\" in catch blocks", tags={"error-handling", "security"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class InstanceofUsedOnExceptionCheck
extends SubscriptionBaseVisitor {
    private final Set<String> caughtVariables = Sets.newHashSet();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CATCH, (Object)Tree.Kind.INSTANCE_OF);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.caughtVariables.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CATCH})) {
            CatchTree catchTree = (CatchTree)tree;
            this.caughtVariables.add(catchTree.parameter().simpleName().name());
        } else if (this.isLeftOperandAnException((InstanceOfTree)tree)) {
            this.addIssue((Tree)((InstanceOfTree)tree).instanceofKeyword(), "Replace the usage of the \"instanceof\" operator by a catch block.");
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CATCH})) {
            CatchTree catchTree = (CatchTree)tree;
            this.caughtVariables.remove(catchTree.parameter().simpleName().name());
        }
    }

    private boolean isLeftOperandAnException(InstanceOfTree tree) {
        return tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.caughtVariables.contains(((IdentifierTree)tree.expression()).name());
    }
}

