/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="MethodCyclomaticComplexity", name="Methods should not be too complex", tags={"brain-overload"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point above the threshold")
public class MethodComplexityCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(key="Threshold", defaultValue="10", description="The maximum authorized complexity.")
    private int max = 10;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        int complexity = this.context.getComplexity((Tree)methodTree);
        if (complexity > this.max) {
            this.addIssue(tree, MessageFormat.format("The Cyclomatic Complexity of this method \"{0}\" is {1,number,integer} which is greater than {2,number,integer} authorized.", methodTree.simpleName().name(), complexity, this.max), (double)complexity - (double)this.max);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

