/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ObjectFinalizeCheck", name="The Object.finalize() method should not be called", tags={"cert", "cwe", "security"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ObjectFinalizeCheck
extends SubscriptionBaseVisitor {
    private boolean isInFinalizeMethod = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.isInFinalizeMethod = ObjectFinalizeCheck.isFinalizeMethodMember((MethodTree)tree);
        } else {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            String name = "";
            if (methodInvocationTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                name = ((IdentifierTree)methodInvocationTree.methodSelect()).name();
            } else if (methodInvocationTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                name = ((MemberSelectExpressionTree)methodInvocationTree.methodSelect()).identifier().name();
            }
            if (!this.isInFinalizeMethod && "finalize".equals(name) && methodInvocationTree.arguments().isEmpty()) {
                this.addIssue(tree, "Remove this call to finalize().");
            }
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && ObjectFinalizeCheck.isFinalizeMethodMember((MethodTree)tree)) {
            this.isInFinalizeMethod = false;
        }
    }

    private static boolean isFinalizeMethodMember(MethodTree methodTree) {
        TypeTree returnType = methodTree.returnType();
        boolean returnVoid = returnType != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        return returnVoid && "finalize".equals(methodTree.simpleName().name());
    }
}

