/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1444", name="\"public static\" fields should be constant", tags={"cert", "cwe", "security"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="20min")
public class PublicStaticFieldShouldBeFinalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || tree.is(new Tree.Kind[]{Tree.Kind.ENUM})) {
            for (Tree member : tree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !PublicStaticFieldShouldBeFinalCheck.isPublicStaticNotFinal((VariableTree)member)) continue;
                this.context.addIssue(member, (JavaCheck)this, "Make this \"public static " + ((VariableTree)member).simpleName() + "\" field final");
            }
        }
        super.visitClass(tree);
    }

    private static boolean isPublicStaticNotFinal(VariableTree tree) {
        boolean isPublic = false;
        boolean isStatic = false;
        boolean isFinal = false;
        for (ModifierKeywordTree modifierKeywordTree : tree.modifiers().modifiers()) {
            Modifier modifier = modifierKeywordTree.modifier();
            if (modifier == Modifier.PUBLIC) {
                isPublic = true;
                continue;
            }
            if (modifier == Modifier.STATIC) {
                isStatic = true;
                continue;
            }
            if (modifier != Modifier.FINAL) continue;
            isFinal = true;
        }
        return isPublic && isStatic && !isFinal;
    }
}

