/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.RightCurlyBraceToNextBlockAbstractVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="RightCurlyBraceSameLineAsNextBlockCheck", name="Close curly brace and the next \"else\", \"catch\" and \"finally\" keywords should be located on the same line", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class RightCurlyBraceSameLineAsNextBlockCheck
extends RightCurlyBraceToNextBlockAbstractVisitor {
    @Override
    protected void checkTokenPosition(SyntaxToken syntaxToken, BlockTree previousBlock) {
        if (syntaxToken.line() != previousBlock.closeBraceToken().line()) {
            this.addIssue((Tree)syntaxToken, "Move this \"" + syntaxToken.text() + "\" on the same line that the previous closing curly brace.");
        }
    }
}

