/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1309", name="The @SuppressWarnings annotation should not be used", tags={}, priority=Priority.INFO)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class SuppressWarningsCheck
extends SubscriptionBaseVisitor {
    @RuleProperty(key="listOfWarnings", description="Comma separated list of warnings that can be suppressed (example: unchecked, cast, boxing). An empty list means that no warning can be suppressed.", defaultValue="")
    public String warningsCommaSeparated = "";
    private List<String> allowedWarnings;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        AnnotationTree annotationTree = (AnnotationTree)tree;
        List<String> ruleWarnings = this.getAllowedWarnings();
        if (SuppressWarningsCheck.isJavaLangSuppressWarnings(annotationTree)) {
            if (ruleWarnings.isEmpty()) {
                this.addIssue((Tree)annotationTree, "Suppressing warnings is not allowed");
            } else {
                List<String> suppressedWarnings = SuppressWarningsCheck.getSuppressedWarnings((ExpressionTree)annotationTree.arguments().get(0));
                ArrayList issues = Lists.newArrayList();
                for (String currentWarning : suppressedWarnings) {
                    if (ruleWarnings.contains(currentWarning)) continue;
                    issues.add(currentWarning);
                }
                if (!issues.isEmpty()) {
                    StringBuilder sb = new StringBuilder("Suppressing the '").append(Joiner.on((String)", ").join((Iterable)issues)).append("' warning").append(issues.size() > 1 ? "s" : "").append(" is not allowed");
                    this.addIssue((Tree)annotationTree, sb.toString());
                }
            }
        }
    }

    private static boolean isJavaLangSuppressWarnings(AnnotationTree tree) {
        return tree.symbolType().is("java.lang.SuppressWarnings");
    }

    private List<String> getAllowedWarnings() {
        if (this.allowedWarnings != null) {
            return this.allowedWarnings;
        }
        this.allowedWarnings = Lists.newArrayList();
        Iterable listOfWarnings = Splitter.on((String)",").trimResults().split((CharSequence)this.warningsCommaSeparated);
        for (String warning : listOfWarnings) {
            if (!StringUtils.isNotBlank((String)warning)) continue;
            this.allowedWarnings.add(warning);
        }
        return this.allowedWarnings;
    }

    private static List<String> getSuppressedWarnings(ExpressionTree argument) {
        ArrayList result = Lists.newArrayList();
        if (argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            result.add(LiteralUtils.trimQuotes((String)((LiteralTree)argument).value()));
        } else if (argument.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            NewArrayTree array = (NewArrayTree)argument;
            for (ExpressionTree expressionTree : array.initializers()) {
                if (!expressionTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) continue;
                result.add(LiteralUtils.trimQuotes((String)((LiteralTree)expressionTree).value()));
            }
        }
        return result;
    }
}

