/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2438", name="\"Threads\" should not be used where \"Runnables\" are expected", tags={"multi-threading", "pitfall"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class ThreadAsRunnableArgumentCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        Arguments arguments;
        Symbol methodSymbol;
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTree nct = (NewClassTree)tree;
            methodSymbol = nct.constructorSymbol();
            arguments = nct.arguments();
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            methodSymbol = mit.symbol();
            arguments = mit.arguments();
        }
        if (!arguments.isEmpty() && methodSymbol.isMethodSymbol()) {
            this.checkArgumentsTypes((List<ExpressionTree>)arguments, (JavaSymbol.MethodJavaSymbol)methodSymbol);
        }
    }

    private void checkArgumentsTypes(List<ExpressionTree> arguments, JavaSymbol.MethodJavaSymbol methodSymbol) {
        List parametersTypes = methodSymbol.parameterTypes();
        if (!parametersTypes.isEmpty()) {
            for (int index = 0; index < arguments.size(); ++index) {
                Type providedType;
                Type expectedType;
                ExpressionTree argument = arguments.get(index);
                if (argument.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || (!(expectedType = ThreadAsRunnableArgumentCheck.getExpectedType(providedType = argument.symbolType(), parametersTypes, index, methodSymbol.isVarArgs())).is("java.lang.Runnable") || !providedType.isSubtypeOf("java.lang.Thread")) && (!expectedType.is("java.lang.Runnable[]") || !providedType.isSubtypeOf("java.lang.Thread[]"))) continue;
                this.addIssue((Tree)argument, ThreadAsRunnableArgumentCheck.getMessage(argument, providedType, index));
            }
        }
    }

    private static Type getExpectedType(Type providedType, List<Type> parametersTypes, int index, boolean varargs) {
        Type lastExpectedType;
        int lastParameterIndex = parametersTypes.size() - 1;
        Type lastParameterType = parametersTypes.get(lastParameterIndex);
        Type type = lastExpectedType = varargs ? ((Type.ArrayType)lastParameterType).elementType() : lastParameterType;
        if (index > lastParameterIndex || index == lastParameterIndex && varargs && !providedType.isArray()) {
            return lastExpectedType;
        }
        return parametersTypes.get(index);
    }

    private static String getMessage(ExpressionTree argument, Type providedType, int index) {
        String array = providedType.isArray() ? "[]" : "";
        return MessageFormat.format("\"{0}\" is a \"Thread{1}\".", ThreadAsRunnableArgumentCheck.getArgName(argument, index), array);
    }

    private static String getArgName(ExpressionTree tree, int index) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree).name();
        }
        return "Argument " + (index + 1);
    }
}

