/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.PatternUtils;
import org.sonar.java.model.PackageUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.PackageDeclarationTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="UndocumentedApi", name="Public types, methods and fields (API) should be documented with Javadoc", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class UndocumentedApiCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private static final String DEFAULT_FOR_CLASSES = "**";
    @RuleProperty(key="forClasses", description="Pattern of classes which should adhere to this constraint. Ex : **.api.**", defaultValue="**")
    public String forClasses = "**";
    private WildcardPattern[] patterns;
    private final Deque<ClassTree> classTrees = Lists.newLinkedList();
    private final Deque<Tree> currentParents = Lists.newLinkedList();
    private PublicApiChecker publicApiChecker;
    private String packageName;
    private final Pattern setterPattern = Pattern.compile("set[A-Z].*");
    private final Pattern getterPattern = Pattern.compile("(get|is)[A-Z].*");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.classTrees.clear();
        this.currentParents.clear();
        this.publicApiChecker = PublicApiChecker.newInstanceWithAccessorsHandledAsMethods();
        this.packageName = "";
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.packageName = PackageUtils.packageName((PackageDeclarationTree)tree.packageDeclaration(), (String)"/");
        super.visitCompilationUnit(tree);
    }

    public void visitNewClass(NewClassTree tree) {
    }

    public void visitClass(ClassTree tree) {
        this.visitNode((Tree)tree);
        super.visitClass(tree);
        this.classTrees.pop();
        this.currentParents.pop();
    }

    public void visitVariable(VariableTree tree) {
        this.visitNode((Tree)tree);
        super.visitVariable(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.visitNode((Tree)tree);
        super.visitMethod(tree);
        this.currentParents.pop();
    }

    private void visitNode(Tree tree) {
        if (!this.isExcluded(tree)) {
            String javadoc = PublicApiChecker.getApiJavadoc((Tree)tree);
            if (javadoc == null || UndocumentedApiCheck.isEmptyJavadoc(javadoc)) {
                this.context.addIssue(tree, (JavaCheck)this, "Document this public " + UndocumentedApiCheck.getType(tree) + ".");
            } else if (!javadoc.contains("{@inheritDoc}")) {
                List<String> undocumentedParameters = UndocumentedApiCheck.getUndocumentedParameters(javadoc, UndocumentedApiCheck.getParameters(tree));
                if (!undocumentedParameters.isEmpty()) {
                    this.context.addIssue(tree, (JavaCheck)this, "Document the parameter(s): " + Joiner.on((String)", ").join(undocumentedParameters));
                }
                if (this.hasNonVoidReturnType(tree) && !UndocumentedApiCheck.hasReturnJavadoc(javadoc)) {
                    this.context.addIssue(tree, (JavaCheck)this, "Document this method return value.");
                }
            }
        }
    }

    private static boolean isEmptyJavadoc(String javadoc) {
        String cleanedupJavadoc = javadoc.trim().substring(3).replace("*/", "").replace("*", "").trim();
        return StringUtils.isBlank((String)cleanedupJavadoc);
    }

    private static String getType(Tree tree) {
        String result = "";
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            result = "class";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.INTERFACE})) {
            result = "interface";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM})) {
            result = "enum";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE})) {
            result = "annotation";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
            result = "constructor";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            result = "method";
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            result = "field";
        }
        return result;
    }

    private boolean isExcluded(Tree tree) {
        return !this.isPublicApi(tree) || this.isAccessor(tree) || !this.isMatchingPattern();
    }

    private boolean isAccessor(Tree tree) {
        if (!this.classTrees.isEmpty() && !this.classTrees.peek().is(new Tree.Kind[]{Tree.Kind.INTERFACE}) && tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            MethodTree methodTree = (MethodTree)tree;
            String name = methodTree.simpleName().name();
            return this.setterPattern.matcher(name).matches() && methodTree.parameters().size() == 1 || this.getterPattern.matcher(name).matches() && methodTree.parameters().isEmpty();
        }
        return false;
    }

    private boolean isPublicApi(Tree tree) {
        Tree currentParent = this.currentParents.peek();
        if (tree.is(CLASS_KINDS)) {
            this.classTrees.push((ClassTree)tree);
            this.currentParents.push(tree);
        } else if (tree.is(METHOD_KINDS)) {
            this.currentParents.push(tree);
        }
        return this.publicApiChecker.isPublicApi(currentParent, tree);
    }

    private boolean isMatchingPattern() {
        return WildcardPattern.match((WildcardPattern[])this.getPatterns(), (String)this.className());
    }

    private String className() {
        String className = this.packageName;
        IdentifierTree identifierTree = this.classTrees.peek().simpleName();
        if (identifierTree != null) {
            className = className + "/" + identifierTree.name();
        }
        return className;
    }

    private WildcardPattern[] getPatterns() {
        if (this.patterns == null) {
            this.patterns = PatternUtils.createPatterns(this.forClasses);
        }
        return this.patterns;
    }

    private static List<String> getUndocumentedParameters(String javadoc, List<String> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String parameter : parameters) {
            if (UndocumentedApiCheck.hasParamJavadoc(javadoc, parameter)) continue;
            builder.add((Object)parameter);
        }
        return builder.build();
    }

    private static List<String> getParameters(Tree tree) {
        ImmutableList.Builder builder;
        block3: {
            block2: {
                builder = ImmutableList.builder();
                if (!tree.is(METHOD_KINDS)) break block2;
                MethodTree methodTree = (MethodTree)tree;
                for (VariableTree variableTree : methodTree.parameters()) {
                    builder.add((Object)variableTree.simpleName().name());
                }
                break block3;
            }
            if (!tree.is(CLASS_KINDS)) break block3;
            for (TypeParameterTree typeParam : ((ClassTree)tree).typeParameters()) {
                builder.add((Object)("<" + typeParam.identifier().name() + ">"));
            }
        }
        return builder.build();
    }

    private static boolean hasParamJavadoc(String comment, String parameter) {
        return comment.matches("(?s).*@param\\s++" + parameter + ".*");
    }

    private boolean hasNonVoidReturnType(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !this.classTrees.peek().is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE})) {
            TypeTree returnType = ((MethodTree)tree).returnType();
            return returnType == null || !returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) || !"void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }

    private static boolean hasReturnJavadoc(String comment) {
        return comment.contains("@return");
    }
}

