/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1939", name="Extensions and implementations should not be redundant", tags={"clumsy"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="1min")
public class UselessExtendsCheck
extends SubscriptionBaseVisitor
implements JavaFileScanner {
    private static final String ERROR_MESSAGE = "\"%s\" is listed multiple times.";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        TypeTree superClassTree = classTree.superClass();
        if (superClassTree != null && superClassTree.symbolType().is("java.lang.Object")) {
            this.addIssue((Tree)superClassTree, "\"Object\" should not be explicitly extended.");
        }
        HashSet<Type> interfaces = new HashSet<Type>();
        for (TypeTree superInterfaceTree : classTree.superInterfaces()) {
            Type interfaceType = superInterfaceTree.symbolType();
            if (interfaceType.isClass()) {
                String interfaceName = interfaceType.fullyQualifiedName();
                if (interfaces.contains(interfaceType)) {
                    this.addIssue((Tree)superInterfaceTree, String.format(ERROR_MESSAGE, interfaceName));
                } else {
                    this.checkExtending(classTree, interfaceType, interfaceName);
                }
                interfaces.add(interfaceType);
                continue;
            }
            this.checkExtending(classTree, superInterfaceTree);
        }
    }

    private void checkExtending(ClassTree classTree, Type currentInterfaceType, String currentInterfaceName) {
        for (TypeTree superInterfaceTree : classTree.superInterfaces()) {
            if (currentInterfaceType.equals(superInterfaceTree.symbolType()) || !currentInterfaceType.isSubtypeOf(superInterfaceTree.symbolType())) continue;
            String interfaceName = superInterfaceTree.symbolType().fullyQualifiedName();
            this.addIssue((Tree)superInterfaceTree, String.format("\"%s\" is a \"%s\" so \"%s\" can be removed from the extension list.", currentInterfaceName, interfaceName, interfaceName));
        }
    }

    private void checkExtending(ClassTree classTree, TypeTree currentInterfaceTree) {
        for (TypeTree superInterfaceTree : classTree.superInterfaces()) {
            if (currentInterfaceTree.equals(superInterfaceTree) || !SyntacticEquivalence.areEquivalent((Tree)currentInterfaceTree, (Tree)superInterfaceTree)) continue;
            this.addIssue((Tree)superInterfaceTree, String.format(ERROR_MESSAGE, this.extractInterfaceName(currentInterfaceTree)));
        }
    }

    private String extractInterfaceName(TypeTree interfaceTree) {
        if (interfaceTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)interfaceTree).name();
        }
        if (interfaceTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)interfaceTree).identifier().name();
        }
        if (interfaceTree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            return this.extractInterfaceName(((ParameterizedTypeTree)interfaceTree).type());
        }
        throw new IllegalStateException("cannot process " + interfaceTree.toString());
    }
}

