/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractMethodDetection
extends SubscriptionBaseVisitor {
    private List<MethodMatcher> matchers;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            for (MethodMatcher invocationMatcher : this.matchers()) {
                this.checkInvocation(tree, invocationMatcher);
            }
        }
    }

    private void checkInvocation(Tree tree, MethodMatcher invocationMatcher) {
        NewClassTree newClassTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            if (invocationMatcher.matches(mit)) {
                this.onMethodInvocationFound(mit);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && invocationMatcher.matches(newClassTree = (NewClassTree)tree)) {
            this.onConstructorFound(newClassTree);
        }
    }

    protected abstract List<MethodMatcher> getMethodInvocationMatchers();

    protected void onMethodInvocationFound(MethodInvocationTree mit) {
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
    }

    private List<MethodMatcher> matchers() {
        if (this.matchers == null) {
            this.matchers = this.getMethodInvocationMatchers();
        }
        return this.matchers;
    }
}

