/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.symexec;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

class AssignedSymbolExtractor {
    private final Visitor visitor = new Visitor();

    AssignedSymbolExtractor() {
    }

    public Set<Symbol.VariableSymbol> findAssignedVariables(Tree tree) {
        this.visitor.assignedSymbols = new HashSet<Symbol.VariableSymbol>();
        tree.accept((TreeVisitor)this.visitor);
        return this.visitor.assignedSymbols;
    }

    private static class Visitor
    extends BaseTreeVisitor {
        @VisibleForTesting
        Set<Symbol.VariableSymbol> assignedSymbols;

        private Visitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.registerAssignedSymbol(((IdentifierTree)tree.variable()).symbol());
            }
            super.visitAssignmentExpression(tree);
        }

        @VisibleForTesting
        void registerAssignedSymbol(Symbol symbol) {
            if (symbol.isVariableSymbol()) {
                this.assignedSymbols.add((Symbol.VariableSymbol)symbol);
            }
        }
    }
}

