/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1294", name="The Array.equals(Object obj) method should not be used", priority=Priority.CRITICAL, status="DEPRECATED", tags={})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayEqualsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        MemberSelectExpressionTree mset;
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "equals".equals((mset = (MemberSelectExpressionTree)tree.methodSelect()).identifier().name()) && mset.expression().symbolType().isArray()) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Use the '==' operator instead of calling the equals() method to prevent any misunderstandings");
        }
        super.visitMethodInvocation(tree);
    }
}

