/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1940", name="Boolean checks should not be inverted", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class BooleanInversionCheck
extends SubscriptionBaseVisitor {
    private static final Map<String, String> OPERATORS = ImmutableMap.builder().put((Object)"==", (Object)"!=").put((Object)"!=", (Object)"==").put((Object)"<", (Object)">=").put((Object)">", (Object)"<=").put((Object)"<=", (Object)">").put((Object)">=", (Object)"<").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.LOGICAL_COMPLEMENT);
    }

    public void visitNode(Tree tree) {
        ExpressionTree expression = ExpressionsHelper.skipParentheses(((UnaryExpressionTree)tree).expression());
        if (expression.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN_OR_EQUAL_TO})) {
            this.context.addIssue(tree, (JavaCheck)this, "Use the opposite operator (\"" + OPERATORS.get(((BinaryExpressionTree)expression).operatorToken().text()) + "\") instead.");
        }
    }
}

