/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ClassCyclomaticComplexity", name="Classes should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point over the threshold")
public class ClassComplexityCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 200;
    @RuleProperty(description="Maximum complexity allowed.", defaultValue="200")
    private int max = 200;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        List complexity = this.context.getComplexityNodes(tree);
        int size = complexity.size();
        if (size > this.max) {
            ArrayList<JavaFileScannerContext.Location> flow = new ArrayList<JavaFileScannerContext.Location>();
            for (Tree element : complexity) {
                flow.add(new JavaFileScannerContext.Location("Complexity + 1", element));
            }
            ClassTree classTree = (ClassTree)tree;
            SyntaxToken report = classTree.simpleName() == null ? classTree.openBraceToken() : classTree.simpleName();
            this.reportIssue((Tree)report, "The Cyclomatic Complexity of this class is " + size + " which is greater than " + this.max + " authorized.", flow, size - this.max);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

