/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2974", name="Classes without \"public\" constructors should be \"final\"", priority=Priority.MAJOR, tags={"design"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class FinalClassCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (FinalClassCheck.hasOnlyPrivateConstructors(classTree) && !ModifiersUtils.hasModifier((ModifiersTree)classTree.modifiers(), (Modifier)Modifier.FINAL)) {
            this.addIssue((Tree)classTree, "Make this class \"final\" or add a public constructor.");
        }
    }

    private static boolean hasOnlyPrivateConstructors(ClassTree classTree) {
        boolean hasConstructor = false;
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) continue;
            hasConstructor = true;
            if (ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)member).modifiers(), (Modifier)Modifier.PRIVATE)) continue;
            return false;
        }
        return hasConstructor;
    }
}

