/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S881", name="Increment (++) and decrement (--) operators should not be mixed with other operators in an expression", priority=Priority.MAJOR, tags={"cert", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class IncrementDecrementInSubExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expressionTree = tree.expression();
        if (IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement((Tree)expressionTree)) {
            UnaryExpressionTree unaryExpressionTree = (UnaryExpressionTree)expressionTree;
            expressionTree = unaryExpressionTree.expression();
        }
        this.scan((Tree)expressionTree);
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        if (IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement((Tree)tree)) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Extract this increment or decrement operator into a dedicated statement.");
        }
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression == null || !IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement((Tree)expression)) {
            this.scan((Tree)expression);
        }
    }

    private static boolean isIncrementOrDecrement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_INCREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT});
    }
}

