/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1201", name="Methods named \"equals\" should override Object.equals(Object)", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class MethodNamedEqualsCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if ("equals".equalsIgnoreCase(methodTree.simpleName().name()) && !MethodNamedEqualsCheck.hasSingleObjectParameter(methodTree)) {
            this.addIssue(tree, "Either override Object.equals(Object), or totally rename the method to prevent any confusion.");
        }
    }

    private static boolean hasSingleObjectParameter(MethodTree methodTree) {
        List parameters = methodTree.parameters();
        if (parameters.size() != 1) {
            return false;
        }
        return MethodNamedEqualsCheck.isObjectType((VariableTree)parameters.get(0));
    }

    private static boolean isObjectType(VariableTree variableTree) {
        String type = MethodNamedEqualsCheck.concatenate((ExpressionTree)variableTree.type());
        return "Object".equals(type) || "java.lang.Object".equals(type);
    }

    private static String concatenate(ExpressionTree tree) {
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }
}

