/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2675", name="\"readObject\" should not be \"synchronized\"", priority=Priority.MAJOR, tags={"confusing"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class ReadObjectSynchronizedCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree;
        if (this.hasSemantic() && ReadObjectSynchronizedCheck.implementsSerializable(classTree = (ClassTree)tree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !ReadObjectSynchronizedCheck.isSynchronized((MethodTree)member) || !ReadObjectSynchronizedCheck.isReadObject((MethodTree)member)) continue;
                this.addIssue(member, "Remove the \"synchronized\" keyword from this method.");
            }
        }
    }

    private static boolean implementsSerializable(ClassTree classTree) {
        return classTree.symbol().type().isSubtypeOf("java.io.Serializable");
    }

    private static boolean isSynchronized(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.SYNCHRONIZED);
    }

    private static boolean isReadObject(MethodTree methodTree) {
        if (!"readObject".equals(methodTree.simpleName().name())) {
            return false;
        }
        return methodTree.parameters().size() == 1 && ((VariableTree)methodTree.parameters().get(0)).type().symbolType().is("java.io.ObjectInputStream");
    }
}

