/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1609", name="@FunctionalInterface annotation should be used to flag Single Abstract Method interfaces", priority=Priority.MAJOR, tags={"java8"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="2min")
public class SAMAnnotatedCheck
extends IssuableSubscriptionVisitor {
    private static final ImmutableMultimap<String, List<String>> OBJECT_METHODS = new ImmutableMultimap.Builder().put((Object)"equals", (Object)ImmutableList.of((Object)"Object")).put((Object)"getClass", (Object)ImmutableList.of()).put((Object)"hashcode", (Object)ImmutableList.of()).put((Object)"notify", (Object)ImmutableList.of()).put((Object)"notifyAll", (Object)ImmutableList.of()).put((Object)"toString", (Object)ImmutableList.of()).put((Object)"wait", (Object)ImmutableList.of()).put((Object)"wait", (Object)ImmutableList.of((Object)"long")).put((Object)"wait", (Object)ImmutableList.of((Object)"long", (Object)"int")).build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (SAMAnnotatedCheck.hasOneAbstractMethod(classTree) && !SAMAnnotatedCheck.isAnnotated(classTree)) {
            this.addIssue(tree, "Annotate the \"" + classTree.simpleName().name() + "\" interface with the @FunctionInterface annotation");
        }
    }

    private static boolean isAnnotated(ClassTree tree) {
        for (AnnotationTree annotationTree : tree.modifiers().annotations()) {
            TypeTree annotationType = annotationTree.annotationType();
            if (!annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || !"FunctionalInterface".equals(((IdentifierTree)annotationType).name())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOneAbstractMethod(ClassTree classTree) {
        Symbol.TypeSymbol symbol = classTree.symbol();
        if (symbol != null) {
            List types = symbol.interfaces();
            for (Type type : types) {
                if (type.symbol().memberSymbols().isEmpty()) continue;
                return false;
            }
        }
        int methods = 0;
        for (Tree member : classTree.members()) {
            boolean isMethod = member.is(new Tree.Kind[]{Tree.Kind.METHOD});
            if (!isMethod) {
                return false;
            }
            if (!SAMAnnotatedCheck.isNotObjectMethod((MethodTree)member) || !SAMAnnotatedCheck.isNonStaticNonDefaultMethod(member)) continue;
            ++methods;
        }
        return methods == 1;
    }

    private static boolean isNotObjectMethod(MethodTree method) {
        ImmutableCollection methods = OBJECT_METHODS.get((Object)method.simpleName().name());
        if (methods != null) {
            for (List arguments : methods) {
                ArrayList args = Lists.newArrayList((Iterable)arguments);
                if (method.parameters().size() != args.size()) continue;
                for (VariableTree var : method.parameters()) {
                    args.remove(var.type().symbolType().name());
                }
                if (!args.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isNonStaticNonDefaultMethod(Tree memberTree) {
        boolean result = memberTree.is(new Tree.Kind[]{Tree.Kind.METHOD});
        if (result) {
            MethodTree methodTree = (MethodTree)memberTree;
            ModifiersTree modifiers = methodTree.modifiers();
            result = !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC) && !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.DEFAULT);
        }
        return result;
    }
}

